/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRect.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CRect_h	// [
#define Included_CRect_h

#include "pgpClassesConfig.h"
#include <math.h>

_PGP_BEGIN

// Class CRect

class CRect
{
public:
	CRect();
	CRect(LONG left, LONG right = 0, LONG top = 0, LONG bottom = 0);
	CRect(RECT rect);

	CRect&		operator=(const RECT& rect);
	PGPBoolean	operator==(const RECT& rect) const;
	PGPBoolean	operator!=(const RECT& rect) const;

	operator RECT&() {return mRect;}
	operator const RECT&() const {return mRect;}

	operator RECT *() {return &mRect;}
	operator const RECT *() const {return &mRect;}

	const LONG&	Left() const {return mRect.left;}
	LONG&		Left() {return mRect.left;}

	const LONG&	Top() const {return mRect.top;}
	LONG&		Top() {return mRect.top;}

	const LONG&	Right() const {return mRect.right;}
	LONG&		Right() {return mRect.right;}

	const LONG&	Bottom() const {return mRect.bottom;}
	LONG&		Bottom() {return mRect.bottom;}

	PGPUInt32	Height() const;
	PGPUInt32	Width() const;

	PGPBoolean	IsEmpty() const;
	PGPBoolean	PtIn(POINT point) const;

	void	Inflate(PGPInt32 dx, PGPInt32 dy);
	void	Offset(PGPInt32 dx, PGPInt32 dy);
	void	Empty();

private:
	RECT	mRect;
};


// Class CRect member functions

inline 
CRect::CRect()
{
	Empty();
}

inline 
CRect::CRect(LONG left, LONG top, LONG right, LONG bottom)
{
	SetRect(&mRect, left, top, right, bottom);
}

inline 
CRect::CRect(RECT rect)
{
	CopyRect(&mRect, &rect);
}

inline 
CRect& 
CRect::operator=(const RECT& rect)
{
	if (&mRect == &rect)
		return *this;

	CopyRect(&mRect, &rect);
	return *this;
}

inline 
PGPBoolean 
CRect::operator==(const RECT& rect) const
{
	if (&mRect == &rect)
		return TRUE;

	return EqualRect(&mRect, &rect);
}

inline 
PGPBoolean 
CRect::operator!=(const RECT& rect) const
{
	return !operator==(rect);
}

inline 
PGPUInt32 
CRect::Height() const
{
	return abs(Top() - Bottom());
}

inline 
PGPUInt32 
CRect::Width() const
{
	return abs(Right() - Left());
}

inline 
PGPBoolean 
CRect::IsEmpty() const
{
	return IsRectEmpty(&mRect);
}

inline 
PGPBoolean 
CRect::PtIn(POINT point) const
{
	return PtInRect(&mRect, point);
}

inline 
void 
CRect::Inflate(PGPInt32 dx, PGPInt32 dy)
{
	InflateRect(&mRect, dx, dy);
}

inline 
void 
CRect::Offset(PGPInt32 dx, PGPInt32 dy)
{
	OffsetRect(&mRect, dx, dy);
}

inline 
void 
CRect::Empty()
{
	SetRectEmpty(&mRect);
}

_PGP_END

#endif	// ] Included_CRect_h
